/*
   This process writes a single line of 200,000 bytes
   to a pipe connected to its child process. The child
   does not read from stdin for 10 seconds, so the first
   8,000 or so bytes fill up this process's output buffer
   and the pipe buffer and then this process blocks.

   When the child calls nextLine() on its Scanner object,
   that starts to drain the pipe and the parent wakes up
   (even though the parent never calls flush()!). The
   parent can now write an almost unlimited number of
   bytes to the child as the child waits to see an end-of-line
   character (the buffer in the Scanner object just seems to
   grow to hold all the data that comes in while it is waiting
   for an end-of-line). When the parent closes its output stream,
   that also marks end-of-line, so nextLine finally returns
   for the child.

   Notice that this process never calls flush() on its output
   buffer (except for the implicit flush() in the close()).
*/
import java.util.Scanner;
import java.io.*;

public class Ex4_WatchBuffering
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Command line for running the child process.
      String[] cmd = {"java", "Ex4_WatchBuffering_Child"};
      // Execute the command line.
      Process process = Runtime.getRuntime().exec(cmd);

      // A stream that writes data to the child's stdin stream (the "pipe").
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );

      // A stream that reads data from the child's stdout stream.
      final Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a "pump" between the child's output stream and stdout.
      new Thread(new Runnable(){public void run()
      {while(stdoutOfChild.hasNextLine())
       {String oneLine = stdoutOfChild.nextLine(); // read from output of child
        System.out.println( oneLine );             // write to standard out
       }}}).start();

      // Write 200,000 bytes to the child's input buffer.
      for (int counter = 1; counter < 200000; counter++)
      {
         System.err.println(counter); // report of the number of bytes so far
         stdinOfChild.print("a");
      }
      stdinOfChild.close();

      process.waitFor();  // throws InterruptedException
   }
}